/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.overlay;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlayMenuBar;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlayUI;
import de.keksuccino.fancymenu.customization.overlay.DebugOverlay;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.ScreenKeyPressedEvent;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.auth.ModValidator;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_11908;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizationOverlay
implements FancyMenuUiComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, ConsumingSupplier<class_437, Boolean>> OVERLAY_VISIBILITY_CONTROLLERS = new HashMap<String, ConsumingSupplier<class_437, Boolean>>();
    private static CustomizationOverlayMenuBar overlayMenuBar;
    private static DebugOverlay debugOverlay;
    private static boolean isValidFancyMenu;

    public static void init() {
        EventHandler.INSTANCE.registerListenersOf(new CustomizationOverlay());
    }

    public static void rebuildOverlay() {
        overlayMenuBar = CustomizationOverlayUI.buildMenuBar(overlayMenuBar == null || overlayMenuBar.isExpanded());
        CustomizationOverlay.rebuildDebugOverlay();
    }

    public static void rebuildDebugOverlay() {
        if (debugOverlay != null) {
            debugOverlay.resetOverlay();
        }
        debugOverlay = CustomizationOverlayUI.buildDebugOverlay(overlayMenuBar);
    }

    @Nullable
    public static CustomizationOverlayMenuBar getCurrentMenuBarInstance() {
        return overlayMenuBar;
    }

    @Nullable
    public static DebugOverlay getCurrentDebugOverlayInstance() {
        return debugOverlay;
    }

    public static boolean isOverlayVisible(@Nullable class_437 currentScreen) {
        if (FancyMenu.getOptions().modpackMode.getValue().booleanValue()) {
            return false;
        }
        if (!FancyMenu.getOptions().showCustomizationOverlay.getValue().booleanValue()) {
            return false;
        }
        if (currentScreen == null) {
            return false;
        }
        for (ConsumingSupplier<class_437, Boolean> s : OVERLAY_VISIBILITY_CONTROLLERS.values()) {
            if (s.get(currentScreen).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String registerOverlayVisibilityController(@NotNull ConsumingSupplier<class_437, Boolean> visibilityController) {
        String id = ScreenCustomization.generateUniqueIdentifier();
        OVERLAY_VISIBILITY_CONTROLLERS.put(id, Objects.requireNonNull(visibilityController));
        return id;
    }

    public static void unregisterOverlayVisibilityController(@NotNull String identifier) {
        OVERLAY_VISIBILITY_CONTROLLERS.remove(Objects.requireNonNull(identifier));
    }

    @EventListener(priority=-1000)
    public void onInitScreenPost(InitOrResizeScreenCompletedEvent e) {
        if (!ScreenCustomization.isScreenBlacklisted(e.getScreen().getClass().getName()) && CustomizationOverlay.isOverlayVisible(e.getScreen())) {
            CustomizationOverlay.rebuildOverlay();
            if (overlayMenuBar != null && debugOverlay != null) {
                CustomizableScreen c;
                class_437 class_4372;
                if (FancyMenu.getOptions().showCustomizationOverlay.getValue().booleanValue()) {
                    e.getWidgets().add(0, overlayMenuBar);
                    class_4372 = e.getScreen();
                    if (class_4372 instanceof CustomizableScreen) {
                        c = (CustomizableScreen)class_4372;
                        c.removeOnInitChildrenFancyMenu().add(overlayMenuBar);
                    }
                }
                if (FancyMenu.getOptions().showDebugOverlay.getValue().booleanValue()) {
                    e.getWidgets().add(1, (class_364)debugOverlay);
                    class_4372 = e.getScreen();
                    if (class_4372 instanceof CustomizableScreen) {
                        c = (CustomizableScreen)class_4372;
                        c.removeOnInitChildrenFancyMenu().add((class_364)debugOverlay);
                    }
                }
            } else {
                LOGGER.error("[FANCYMENU] Failed to rebuild overlay!", (Throwable)new NullPointerException("Debug or Customization overlay was NULL!"));
            }
        }
    }

    @EventListener(priority=-1)
    public void onRenderPost(RenderScreenEvent.Post e) {
        if (!isValidFancyMenu) {
            ModValidator.renderInvalidError(e.getGraphics());
        }
        if (!ScreenCustomization.isScreenBlacklisted(e.getScreen().getClass().getName()) && overlayMenuBar != null && debugOverlay != null && CustomizationOverlay.isOverlayVisible(e.getScreen())) {
            if (FancyMenu.getOptions().showDebugOverlay.getValue().booleanValue()) {
                CustomizationOverlay.debugOverlay.allowRender = true;
                debugOverlay.method_25394(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
                CustomizationOverlay.debugOverlay.allowRender = false;
            }
            if (FancyMenu.getOptions().showCustomizationOverlay.getValue().booleanValue()) {
                CustomizationOverlay.overlayMenuBar.allowRender = true;
                overlayMenuBar.method_25394(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
                CustomizationOverlay.overlayMenuBar.allowRender = false;
            }
        }
    }

    @EventListener
    public void onScreenKeyPressed(ScreenKeyPressedEvent e) {
        if (!ScreenCustomization.isScreenBlacklisted(e.getScreen().getClass().getName())) {
            String keyName = e.getKeyName();
            class_11908 event = e.getKeyEvent();
            if (!FancyMenu.getOptions().modpackMode.getValue().booleanValue()) {
                if (keyName.equals("c") && event.method_74240() && event.method_74238()) {
                    FancyMenu.getOptions().showCustomizationOverlay.setValue(FancyMenu.getOptions().showCustomizationOverlay.getValue() == false);
                    ScreenCustomization.reInitCurrentScreen();
                }
                if (keyName.equals("d") && event.method_74240() && event.method_74238()) {
                    FancyMenu.getOptions().showDebugOverlay.setValue(FancyMenu.getOptions().showDebugOverlay.getValue() == false);
                    ScreenCustomization.reInitCurrentScreen();
                }
                if (keyName.equals("r") && event.method_74240() && event.method_74238()) {
                    ScreenCustomization.reloadFancyMenu();
                }
            }
        }
    }

    static {
        isValidFancyMenu = ModValidator.isFancyMenuMetadataValid();
    }
}

